/* randomx.h - a C library to generate pseudo-random numbers */

/* Copyright (C) 2025 anon */
/* All rights reserved */
/* https://anon.w10.site/ */

/* Released under the simplified BSD license */

/* last edit: 02-Dec-2025 */

/* begin */

/* Maximum random number (try to change only with another odd number) */

#define RAND_MAX 32767

unsigned int SEED = 1;
unsigned int TIME = 1;

/* Change SEED value */

void srand(unsigned int seed) {
 SEED = seed;
 TIME = 1;
}

/* Return a pseudo-random number */

int rand(void) {
 SEED += TIME;
 if(SEED != RAND_MAX) {
  while(SEED < RAND_MAX)
   SEED *= SEED + 1;
  while(SEED >= RAND_MAX)
   SEED -= RAND_MAX;
 }
 TIME++;
 return((int)SEED);
}

/* end */
